# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CDVI
                                 A QGIS plugin
 City Disaster Vulnerability Index
                             -------------------
        begin                : 2020-06-11
        copyright            : (C) 2020 by WB
        email                : andlang@outlook.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import pandas as pd


class WeightItem(object):
    def __init__(self, parent_id: str, name: str, weight: str, level: str, children):
        self.id = name if not parent_id else parent_id + "." + name
        self.name = name
        self.weight = weight
        self.level = level
        self.children = children

    @classmethod
    def from_dict(cls, data: dict):
        children = list(map(WeightItem.from_dict, data["children"]))
        return cls(data["id"], data["name"], data["weight"], data["level"], children)


class WeightDataLoader(object):
    def __init__(self, plugin_dir: str, country_abbr: str, city_name: str, city_abbr: str):
        self.plugin_dir = plugin_dir
        self.city_dir = self.plugin_dir + '/data/' + city_name.replace(" ", "") + '_' + country_abbr + '/'
        self.city_abbr = city_abbr

    def get_weight_data(self, selected_id: str) -> WeightItem:
        level1_weights = pd.read_csv(self.plugin_dir + '/data/Weights/level1weights.csv')
        level2_weights = pd.read_csv(self.plugin_dir + '/data/Weights/level2weights.csv')

        item = WeightItem("", "total", 1, "1.0", [])

        for _, level1_row in level1_weights.iterrows():
            level1_item_name = level1_row['Pillar_Name']
            level1_item = WeightItem(item.id, level1_item_name, level1_row[selected_id], "2.0", [])
            for _, level2_row in level2_weights.query('Pillar_Name == @level1_item_name').iterrows():
                level2_item_name = level2_row['Component_Name']
                level2_item = WeightItem(level1_item.id, level2_item_name, level2_row[selected_id], "3.0", [])
                for _, level3_row in pd.read_csv(
                        self.city_dir + 'Weights/level3weights_' + level2_row[
                            'Pillar_Name'] + "_" + self.city_abbr + '.csv') \
                        .query('Component_Name == @level2_item_name').iterrows():
                    level2_item.children.append(
                        WeightItem(level2_item.id, level3_row['Indicator_Name'], level3_row[selected_id], "4.0", []))

                level1_item.children.append(level2_item)

            item.children.append(level1_item)

        return item
