# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CDVI
                                 A QGIS plugin
 City Disaster Vulnerability Index
                             -------------------
        begin                : 2020-06-11
        copyright            : (C) 2020 by WB
        email                : andlang@outlook.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import json

from qgis.PyQt.QtGui import QStandardItem
from qgis.core import (
    QgsProject,
)


def create_item(name):
    item = QStandardItem(name)
    item.setEditable(False)
    return item


def write_layer_suppl_info_to_qgs(layer_id: str, suppl_info: dict):
    QgsProject.instance().writeEntry(
        'cdvi', layer_id,
        json.dumps(suppl_info,
                   sort_keys=False,
                   indent=2,
                   separators=(',', ': '),
                   default=lambda obj: obj.__dict__))

    read_layer_suppl_info_from_qgs(layer_id, suppl_info)


def read_layer_suppl_info_from_qgs(layer_id: str, supplemental_information: dict):
    layer_suppl_info_str, _ = QgsProject.instance().readEntry('cdvi', layer_id, '{}')
    supplemental_information[layer_id] = json.loads(layer_suppl_info_str)


def get_layer_suppl_info_from_qgs(layer_id: str) -> dict:
    layer_suppl_info_str, _ = QgsProject.instance().readEntry('cdvi', layer_id, '{}')
    return json.loads(layer_suppl_info_str)


def try_float(x: str) -> float:
    try:
        return float(x)
    except (ValueError, TypeError):
        return 0
