# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CDVI
                                 A QGIS plugin
 City Disaster Vulnerability Index
                             -------------------
        begin                : 2020-06-11
        copyright            : (C) 2020 by WB
        email                : andlang@outlook.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import numpy as np
import pandas as pd


def linear(df: pd.DataFrame, inverse: bool) -> pd.DataFrame:
    denominator = (df.max() - df.min())
    if denominator == 0:
        return -999
    if inverse:
        return 1 - (df - df.min()) / denominator
    return (df - df.min()) / denominator


def z_score(df: pd.DataFrame, inverse: bool) -> pd.DataFrame:
    if inverse:
        return -(df - df.mean()) / df.std()
    return (df - df.mean()) / df.std()


def logarithmic(df: pd.DataFrame, inverse: bool) -> pd.DataFrame:
    if inverse:
        raise Exception("Not implemented")
    return np.log10(df)


def sigmoid(df: pd.DataFrame, inverse: bool) -> pd.DataFrame:
    if inverse:
        return np.log(df / (1 - df))
    return 1 / (1 + np.exp(-df))


def quadratic(df: pd.DataFrame, inverse: bool) -> pd.DataFrame:
    if inverse:
        return 1 - df ** 2 / df.max() ** 2
    return df ** 2 / df.max() ** 2
