# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CDVI
                                 A QGIS plugin
 City Disaster Vulnerability Index
                             -------------------
        begin                : 2020-06-11
        copyright            : (C) 2020 by WB
        email                : andlang@outlook.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import csv
from typing import Iterable
import pandas as pd


class DataLoader(object):
    def __init__(self, plugin_dir: str):
        self.plugin_dir = plugin_dir

    def get_cities(self) -> Iterable[str]:
        with open(self.plugin_dir + '/data/cities.csv', newline='') as file:
            reader = csv.reader(file)
            cities = list(reader)
        return cities

    def get_setup_options(self) -> pd.DataFrame:
        path = self.plugin_dir + '/data/SetupOptions.csv'
        return pd.read_csv(path)
