# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CDVI
                                 A QGIS plugin
 City Disaster Vulnerability Index
                             -------------------
        begin                : 2020-06-11
        copyright            : (C) 2020 by WB
        email                : andlang@outlook.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

import pandas as pd
from cdvi.ui.table_widget import TableWidget
from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import QDialog

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'what_if_multipliers.ui'))


class WhatIfMultipliers(QDialog, FORM_CLASS):
    def __init__(self, data: pd.DataFrame):
        self.data = data

        QDialog.__init__(self)

        self.setupUi(self)

        self.table = TableWidget(data)
        self.vertical_layout.layout().addWidget(self.table)
