# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CDVI
                                 A QGIS plugin
 City Disaster Vulnerability Index
                             -------------------
        begin                : 2020-06-11
        copyright            : (C) 2020 by WB
        email                : andlang@outlook.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

import pandas as pd
from cdvi.ui.what_if_multipliers import WhatIfMultipliers
from qgis.PyQt import uic
from qgis.PyQt.QtCore import pyqtSlot
from qgis.PyQt.QtWidgets import QDialog

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'what_if_dialog.ui'))


class WhatIfDialog(QDialog, FORM_CLASS):
    def __init__(self, multipliers: pd.DataFrame):
        self.multipliers = multipliers

        QDialog.__init__(self)

        self.setupUi(self)

    @pyqtSlot()
    def on_show_matrix_button_clicked(self):
        dlg = WhatIfMultipliers(self.multipliers)
        dlg.show()
        # Run the dialog event loop
        result = dlg.exec_()
        # See if OK was pressed
        if result:
            pass
