# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CDVI
                                 A QGIS plugin
 City Disaster Vulnerability Index
                             -------------------
        begin                : 2020-06-11
        copyright            : (C) 2020 by WB
        email                : andlang@outlook.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import json
import os
from copy import deepcopy

from cdvi.utilities.weight_data_loader import WeightItem
from qgis.PyQt import uic
from qgis.PyQt.QtCore import (
    Qt, QUrl, pyqtProperty, pyqtSignal)
from qgis.PyQt.QtWebKit import QWebSettings
from qgis.PyQt.QtWidgets import QDialog, QDialogButtonBox

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'weight_data_dialog.ui'))


class WeightDataDialog(QDialog, FORM_CLASS):
    json_updated = pyqtSignal(['QVariantMap'], name='json_updated')

    def __init__(self, weights: WeightItem, changeable: bool):
        self.changeable = changeable
        QDialog.__init__(self)

        # Set up the user interface from Designer.
        self.setupUi(self)
        self.ok_button = self.buttonBox.button(QDialogButtonBox.Ok)

        self.modified_weights = None
        self.weights = deepcopy(weights)

        self.web_view = self.web_view
        self.web_view.load(QUrl('qrc:/plugins/cdvi/weight_data.html'))

        self.frame = self.web_view.page().mainFrame()

        self.frame.javaScriptWindowObjectCleared.connect(self.setup_js)
        self.web_view.loadFinished.connect(self.show_tree)
        self.json_updated.connect(self.handle_json_updated)

        self.web_view.setContextMenuPolicy(Qt.NoContextMenu)

        self.web_view.settings().setAttribute(
            QWebSettings.JavascriptEnabled, True)

    def setup_js(self):
        self.frame.addToJavaScriptWindowObject('qt_page', self)

    def show_tree(self):
        self.frame.evaluateJavaScript('init_tree()')

    def handle_json_updated(self, data):
        self.modified_weights = data

    @pyqtProperty(str)
    def json_str(self):
        return json.dumps(self.weights, default=lambda obj: obj.__dict__)

    @pyqtProperty(bool)
    def CHANGEABLE(self):
        return self.changeable
