# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CDVI
                                 A QGIS plugin
 City Disaster Vulnerability Index
                             -------------------
        begin                : 2020-06-11
        copyright            : (C) 2020 by WB
        email                : andlang@outlook.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from cdvi.ui.weight_data_dialog import WeightDataDialog
from cdvi.utilities.utils import get_layer_suppl_info_from_qgs
from cdvi.utilities.weight_data_loader import WeightDataLoader
from qgis.PyQt import uic
from qgis.PyQt.QtCore import pyqtSlot
from qgis.PyQt.QtWidgets import QDialog
from qgis.core import QgsMapLayer

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'calculate_cdvi_dialog.ui'))


class CalculateCDVIDialog(QDialog, FORM_CLASS):
    def __init__(self, plugin_dir: str, layer: QgsMapLayer):
        self.plugin_dir = plugin_dir
        self.layer = layer
        QDialog.__init__(self)

        self.setupUi(self)

    @pyqtSlot()
    def on_show_cdvi_button_clicked(self):
        suppl_info = get_layer_suppl_info_from_qgs(self.layer.id())
        weight_data = WeightDataLoader(self.plugin_dir, suppl_info['country_abbr'], suppl_info['city_name'],
                                       suppl_info['city_abbr']).get_weight_data(
            str(suppl_info['sector']) + '_' + str(suppl_info['context']))

        dlg = WeightDataDialog(weight_data, False)
        dlg.show()
        # Run the dialog event loop
        result = dlg.exec_()
        # See if OK was pressed
        if result:
            pass
