# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CDVI
                                 A QGIS plugin
 City Disaster Vulnerability Index
                             -------------------
        begin                : 2020-06-11
        copyright            : (C) 2020 by WB
        email                : andlang@outlook.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from typing import List

from cdvi.ui.multi_select_combo_box import MultiSelectComboBox
from cdvi.utilities.city_data_loader import CityDataLoader
from qgis.PyQt import uic
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import QDialog, QLabel

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'add_indicators.ui'))


class AddIndicatorsDialog(QDialog, FORM_CLASS):
    def __init__(self, plugin_dir: str, selected_city: List[str], selected_pillar: str, selected_items: List[str]):
        self.plugin_dir = plugin_dir
        self.selected_city = selected_city
        self.city_data_loader = CityDataLoader(self.plugin_dir, selected_city[1], selected_city[0], selected_city[2])

        self.pillars = sorted(self.city_data_loader.get_pillars())

        QDialog.__init__(self)

        self.setupUi(self)

        self.database_cbx.clear()
        self.database_cbx.addItems(self.pillars)
        self.database_cbx.currentIndexChanged.connect(self.database_selection_changed)

        self.indicator_lbl = QLabel('Select Indicators')
        self.indicator_multiselect = MultiSelectComboBox(self)
        self.vertical_layout.layout().addWidget(self.indicator_lbl)
        self.vertical_layout.layout().addWidget(self.indicator_multiselect)

        index = self.database_cbx.findText(selected_pillar, Qt.MatchFixedString)
        if index >= 0:
            self.selected_pillar = selected_pillar
            self.database_cbx.setCurrentIndex(index)
        else:
            self.selected_pillar = self.pillars[0]

        self.setup_indicator_multiselect()
        self.indicator_multiselect.add_selected_items(selected_items)

    def database_selection_changed(self, i):
        self.selected_pillar = self.pillars[i]
        self.setup_indicator_multiselect()

    def setup_indicator_multiselect(self):
        self.indicator_multiselect.clear()
        self.indicator_multiselect.add_unselected_items(
            self.city_data_loader.combine_data(self.selected_pillar).columns[4:])
