# City Disaster Vulnerability Index (CDVI)

## Purpose and Objectives

The City Disaster Vulnerability Index (CDVI) was developed to provide a holistic
representation of the multiple factors of vulnerability in a small urban area,
identify concentrations of vulnerabilities and subsequently support the
targeting and prioritisation of cross-sector interventions. The index provides a
method to quantitatively assess sub-city areas in terms of their vulnerability
to a variety of shocks and stresses. The multiple attributes and detailed scale
of data within the CDVI enables a range of insights for different decision and
policy makers at the City, regional and national level, including:

- Identifying areas of risk and vulnerability concentration during response and
  recovery efforts, along with for scenario planning exercises for preparation
  and planning activities

- Understanding how these risks can become worse and potential compounding
  impacts, along with the factors that drive and create vulnerability in certain
  areas

- Exploring where the risk can go in the future with the ability to perform
  what-if analysis

- Identifying where interventions should be targeted, on what sectors, and what
  the relative benefits can be.

## The Index

The index was based on a range of research on urban vulnerability and disaster
risk[^1] indices along with input from subject-matter experts. Figure 1 details
the index and how it is divided across four key pillars -- Urban Fabric, Public
Administration & Governance, Enterprise and People. These pillars represent the
key elements of a city -- where people live and work and how services enable
that in a resilient manner.

The specific indicators used within each pillar and component was also
determined based on known available datasets within Latin American cities --
where the tool was trialled. This iterative process of assessing data
availability against component and pillar focus ensured that the index was
robust across cities while still capturing the diversity of information required
to support multi-sectoral interventions.

For each city, a final step of Principal Component Analysis (PCA) was conducted
to ensure the data used captured different aspects of vulnerability and was not
simply repeating the same information in different metrics. In general, this was
not the case, with the PCA not leading to the removal of any metrics given the
highly selective and iterative nature of indicator selection. The PCA results
were also used as an exploratory tool on the input data itself, helping to
establish whether there were any errors in data collection or processing by
highlighting outliers to explore.

The index therefore represents a comprehensive overview of different indicators
of urban vulnerability. To enable effective targeting of interventions from a
sectoral perspective. For the initial set up of the CDVI it was applied to four
different sectors through the use and weightings applied to each of the
indictors, components and pillars. The four sectors were:

- Public health

- Poverty and social protection

- Civil protection and disaster risk management

- Economic development

There was also consideration of the temporal dimension:

- Before an event (shock or stress) -- vulnerability that exists in society and
  leads to increased negative consequences

- During, including the immediate response to an event

- Long term recovery from an event -- building back better and reducing
  vulnerability moving forward

![Overview of City Disaster Vulnerability Index (CDVI)](resources/cdvi.png)

The CDVI therefore represents vulnerability holistically across the four pillars
while still enabling decision makers and planners to focus on specific sectoral
and temporal perspectives, critical for planning and prioritising interventions.

## Weighting

To initialise the index default weights were determined by expert elicitation.
The Analytic Hierarchy Process (AHP) was used for the elicitation processed. The
process is used extensively due to its ability to decompose a problem into a
hierarchical structure especially when applied to decision contexts such as the
CDVI that is designed to support the prioritisation of areas or concentrations
of vulnerability for intervention. AHP supports this by extracting information
through systematic pairwise comparisons, and the weights therefore represent a
trade-off across indicators, or a willingness to forego a given variable in
exchange for another[^2].

As described in Forman[^3], a foundational paper by one of the developers:

> AHP is a compensatory decision methodology because alternatives that are
> efficient with respect to one or more objectives can compensate by their
> performance with respect to other objectives. AHP allows for the application
> of data, experience, insight, and intuition in a logical and thorough way
> within a hierarchy as a whole. In particular, AHP as a weighting method
> enables decision-makers to derive weights as opposed to arbitrarily assigning
> them.

The essence of the comparison is that for a given objective i.e. improving
public health through intervention, which indicator is more important and by how
much. The response is a semantic scale between 1 and 9 where 1 indicates
equality between two individual indicators, while a preference of 9 indicates
that the individual indicator is 9 times more important than the other one.

To determine the initial weights six subject matter experts responded to the AHP
for each of the sectors and then each of the time dimensions. The weights were
averaged across respondents for each sector and then distribution for temporal
dimension was applied to the weights per sector. It is important to remember
though that the implementation of the index means the weights are transparent
and variable meaning they can be tailor based on more local understanding of the
application area.

## Decision Support Tool

The CDVI has also been built into a geospatial decision support tool (DST) to
enable more effective visualisation, useability and engagement at the
city-level. The DST was implemented within [QGIS](https://qgis.org/en/site/), an
open source geographic information system that enables viewing, editing and
analysis of geospatial data, and operates as a
[plugin](https://plugins.qgis.org/). The tool allows users to make specific
selections -- sector, and context / temporal dimension, based on these
selections the index is initialised using appropriate default weights.

To guide the user in understanding the richness of the datasets available the
DST, after user selection of sector and context, the Tool loads pre-selected key
datasets for the city region. For example, in the health sector the location of
health facilities, demographic profiles, and representation of existing medical
conditions are loaded into the map window. This allows the user to begin explore
dimensions of vulnerability prior to loading the full CDVI. Within the plugin
the user can then 'Calculate Vulnerability', that loads the full database of
CDVI information for the urban region. This consists of:

- Initial vector data for key indicators and data based on sector selection.

- A shapefile per CDVI pillar including unweighted indicator values for the
  respective pillar and key contextual data, such as total population or number
  of dwellings. This data is at a small administrative boundary based on data
  availability per urban region of application.

- CDVI shapefile, at the same spatial resolution as the pillar data, showing the
  weighted and normalized components and pillars, along with integrated CDVI
  value. This is based on the weights -- either defaulted based on sector and
  context selection, or edited by the user within the DST.

This implementation within QGIS enables users to explore the CDVI data at
multiple levels of detail, along with how changing weights influences
understanding of vulnerability spatially. It can also be intersected against
other spatial data, imported into the map, such as a flood or earthquake
scenario. This simple analysis with a spatial tool can support decision makers
analyse a range of questions, for example:

- Where are there shortages of public services relative to total and vulnerable
  population groups, and how much investment is required to make this more
  equitable?

- Where are informal workers concentrated and how exposed are they to disasters
  that affect a particular area in the city or transportation routes for that
  area?

- Where do lock downs (through pandemic counter-measures, or natural hazard
  impacts) have greatest impact to place-based workers -- how does this change
  household income and wellbeing & remittances?

- Using a what-if scenario of conflict driven migration what areas are capable
  of supporting IDPs or refugees, how does this influx change the relative
  vulnerability of that area and how does the community compare to others across
  the city (or broader region) to learn what programs and resourcing are
  effective?

- Where should a risk mitigation scheme (e.g. flood defence) be placed to
  support the most economically fragile populations of the city, what benefits
  would it have in terms of reduced workforce interruption?

- What level of cash-transfer and shock responsive social protection is required
  in this area following a disaster impact? Can this understanding support the
  development adaptive social protective in advance?

Further enhancements of the tool with further enable analytical support to
complex public policy and investment decisions. However, the flexible
implementation of the CDVI, within a GIS platform with a range of existing tools
is a significant step forward in more easily integrated risk and vulnerability
analytics into decision making processes making them more transparent, efficient
and equitable.

[^1]:
    Power, C. et. al., (2015). Social and economic vulnerability global
    indicator database handbook. CEDIM Research Report.

    Khazai, B., et. al., (2015) A guide to measuring urban risk resilience:
    principles, tools, and practice of urban indictors. First edition.
    Earthquake Megacities Initiative.

    Daniell, J. E., et. al., (2018). Indirect loss potential index for natural
    disaster for national and subnational analysis. Risk modeling for hazards
    and disasters. <http://dx.doi.org/10.1016/B978-0-12-804071-3.00006-9>.

[^2]:
    OECD (2008). Handbook on constructing composite indicators -- methodology
    and user guide.

[^3]:
    Forman E.H. (1983). The analytic hierarchy process as a decision support
    system, Proceedings of the IEEE Computer society.
